/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.access;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public enum DataAccessor implements ICommonAccessor,
IBlockAccessor,
IDataAccessor,
IEntityAccessor
{
    INSTANCE;

    private class_1937 world;
    private class_1657 player;
    private class_239 hitResult;
    private class_243 renderingVec = null;
    private class_2248 block = class_2246.field_10124;
    private class_2680 state = class_2246.field_10124.method_9564();
    private class_2338 pos = class_2338.field_10980;
    private class_2960 blockRegistryName = class_2378.field_11142.method_10137();
    private class_2586 blockEntity;
    private class_1297 entity;
    private class_2487 serverData = null;
    private long timeLastUpdate = System.currentTimeMillis();
    private double partialFrame;
    private class_1799 stack = class_1799.field_8037;

    @Override
    public class_1937 getWorld() {
        return this.world;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    @Override
    public class_2248 getBlock() {
        return this.block;
    }

    @Override
    public class_2680 getBlockState() {
        return this.state;
    }

    @Override
    public <T extends class_2586> T getBlockEntity() {
        return (T)this.blockEntity;
    }

    @Override
    public <T extends class_1297> T getEntity() {
        return (T)this.entity;
    }

    public void setEntity(class_1297 entity) {
        this.entity = entity;
    }

    @Override
    public class_2338 getPosition() {
        return this.pos;
    }

    @Override
    public class_239 getHitResult() {
        return this.hitResult;
    }

    @Override
    public class_243 getRenderingPosition() {
        return this.renderingVec;
    }

    @Override
    public class_2487 getServerData() {
        if (this.blockEntity != null && this.isTagCorrectBlockEntity(this.serverData)) {
            return this.serverData;
        }
        if (this.entity != null && this.isTagCorrectEntity(this.serverData)) {
            return this.serverData;
        }
        if (this.blockEntity != null) {
            return this.blockEntity.method_38242();
        }
        if (this.entity != null) {
            return this.entity.method_5647(new class_2487());
        }
        return new class_2487();
    }

    public void setServerData(class_2487 tag) {
        this.serverData = tag;
    }

    @Override
    public double getPartialFrame() {
        return this.partialFrame;
    }

    @Override
    public class_2350 getSide() {
        return this.hitResult == null ? null : (this.hitResult.method_17783() == class_239.class_240.field_1331 ? null : ((class_3965)this.hitResult).method_17780());
    }

    @Override
    public class_1799 getStack() {
        return this.stack;
    }

    @Override
    @Deprecated
    public String getModNameFormat() {
        return Waila.CONFIG.get().getFormatting().getModName();
    }

    @Override
    @Deprecated
    public String getBlockNameFormat() {
        return Waila.CONFIG.get().getFormatting().getBlockName();
    }

    @Override
    @Deprecated
    public String getFluidNameFormat() {
        return Waila.CONFIG.get().getFormatting().getFluidName();
    }

    @Override
    @Deprecated
    public String getEntityNameFormat() {
        return Waila.CONFIG.get().getFormatting().getEntityName();
    }

    @Override
    @Deprecated
    public String getRegistryNameFormat() {
        return Waila.CONFIG.get().getFormatting().getRegistryName();
    }

    @Override
    public class_2960 getBlockId() {
        return this.blockRegistryName;
    }

    public void set(class_1937 world, class_1657 player, class_239 hit, class_1297 viewEntity, double partialTicks) {
        this.world = world;
        this.player = player;
        this.hitResult = hit;
        if (this.hitResult.method_17783() == class_239.class_240.field_1332) {
            this.pos = ((class_3965)hit).method_17777();
            this.blockEntity = this.world.method_8321(this.pos);
            this.entity = null;
            this.setState(world.method_8320(this.pos));
        } else if (this.hitResult.method_17783() == class_239.class_240.field_1331) {
            this.entity = ((class_3966)hit).method_17782();
            this.pos = new class_2338(this.entity.method_19538());
            this.blockEntity = null;
            this.setState(class_2246.field_10124.method_9564());
        }
        if (viewEntity != null) {
            double px = viewEntity.field_6014 + (viewEntity.method_23317() - viewEntity.field_6014) * partialTicks;
            double py = viewEntity.field_6036 + (viewEntity.method_23318() - viewEntity.field_6036) * partialTicks;
            double pz = viewEntity.field_5969 + (viewEntity.method_23321() - viewEntity.field_5969) * partialTicks;
            this.renderingVec = new class_243((double)this.pos.method_10263() - px, (double)this.pos.method_10264() - py, (double)this.pos.method_10260() - pz);
            this.partialFrame = partialTicks;
        }
    }

    public void setState(class_2680 state) {
        this.state = state;
        this.block = state.method_26204();
        this.stack = this.block.method_9574((class_1922)this.world, this.pos, state);
        this.blockRegistryName = class_2378.field_11146.method_10221((Object)this.block);
    }

    private boolean isTagCorrectBlockEntity(class_2487 tag) {
        if (tag == null) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.method_10550("x");
        int y = tag.method_10550("y");
        int z = tag.method_10550("z");
        class_2338 hitPos = ((class_3965)this.hitResult).method_17777();
        if (x == hitPos.method_10263() && y == hitPos.method_10264() && z == hitPos.method_10260()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity(class_2487 tag) {
        if (tag == null || !tag.method_10545("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.method_10550("WailaEntityID");
        if (id == this.entity.method_5628()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }
}

